/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.tutorial;

import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.tutorial.Tutorial;
import com.moulberry.axiom.editor.tutorial.TutorialStage;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.tools.rock.RockTool;
import org.jetbrains.annotations.Nullable;

public class TutorialManager {
    private static TutorialStage currentStage = null;

    public static void reset(Tutorial tutorial) {
        tutorial.uncomplete();
        Tutorial.INTRODUCTION.initiateIfNotCompleted();
    }

    public static void initialize() {
        Tutorial.INTRODUCTION.initiateIfNotCompleted();
    }

    public static void setStage(TutorialStage tutorialStage) {
        currentStage = tutorialStage;
    }

    @Nullable
    public static TutorialStage getCurrentStage() {
        return currentStage;
    }

    @Nullable
    public static EditorWindowType getCurrentStageLinkedWindow() {
        if (currentStage == null) {
            return null;
        }
        return currentStage.getLinkedWindow();
    }

    public static void nextTutorialStage() {
        TutorialStage nextStage = currentStage.getNextStage();
        if (nextStage == null) {
            currentStage.getTutorial().complete();
            currentStage = null;
            Configuration.save();
        } else {
            currentStage = nextStage;
            if (currentStage == TutorialStage.TOOL_OPTIONS && !ToolManager.isToolActive()) {
                ToolManager.setTool(RockTool.class);
                ToolManager.setToolSelected(true);
            }
        }
    }
}

